// ft-global.js -- page for any JavaScript functions we need for the Federated Testing GUI

// formatyourthumb.php and testinterface.php both call get_common.py viewform 
// to generate and display a list of attached devices. We use the 
// get_common_get_view_check_selection() function to do some checks on a user's
// selection when they select a device based on the page they're on.
function get_common_get_view_check_selection(id, mounted){

	var page = location.pathname.substring(location.pathname.lastIndexOf("/") + 1);
	
	if (page == "formatyourthumb.php"){ // do formatyourthumb.php checks
		// When the user selects the device they want to format as their log drive on 
		// formatyourthumb.php, we want to do a quick check to see if the device they
		// selected might be their OS drive or a drive w/ user data -- Warn the user!
		var contains_parts = false;
		var is_part = false;

		// check: is the device the user selected a partition itself?
		if (id.search(/sd[a-z][0-9]/) != -1){ 
			contains_parts = true;
			is_part = true;
		} else { // case: user selected a device (vs a partition)
			// Query to see if there are any html elements with ids representing
			// partitions, e.g., sda1. Check: does the device the user selected 
			// have any partitions?
			if (document.getElementById(id+"1")){
				contains_parts = true;
			}		
		}

		// the selected device is a partition itself or contains 1 or more partitions
		if (contains_parts){
			// construct our warning message...
			var msg = "CAUTION!!! The device you selected, "+id+", contains one or more partitions/file systems, e.g., ";
			if (is_part){
				msg += id;
			} else {
				msg += id+"1";
			}
			msg += ". These may contain an OS or data. Continuing with this selection will format this device AND ANY DATA ON THE DEVICE WILL BE LOST! Select 'OK' to keep your selection, 'Cancel' to cancel it.";

			// print our warning and give user chance to undo their selection
			var answer = confirm(msg);
			// if the user selected 'Cancel', undo their selection
			if (!answer) document.getElementById(id).checked = false;
		}		
	} else if (page == "testinterface.php"){  // do testinterface.php checks
		// We want to do some checks on the testinterface.php page. 1st, we want to warn
		// and make it so the user can't try to select/run the test on a partition 
		// (e.g., sda1) vs a device (e.g., sda). 2nd, if the user has selected a device 
		// (vs a partition), we want to check if that device has 1+ partitions on it. 
		// If it does, we want to allow, but warn them off testing w/ that device as 
		// it may contain an OS/user data.
		if (mounted == "mounted"){ // according to get_common.py, id is mounted
			alert("Please unmount "+id+" and press \"F5\" to refresh this page to continue. Tests cannot be run on mounted devices.");
			// Deselect their selection.
			document.getElementById(id).checked = false;			
		} else if (mounted == "has_mounted_fs") { // according to get_common.py, id contains a file system that happens to be mounted
			alert("Device: "+id+" contains a mounted file system. Please unmount the file system and press \"F5\" to refresh this page to continue. Tests cannot be run on devices with mounted file systems.");
			// Deselect their selection.
			document.getElementById(id).checked = false;
		} else if (mounted == "no") {  // according to get_common.py, id is not mounted
			if (id.search(/sd[a-z][0-9]/) != -1){ // case: user selected a partition, e.g., sda1
				// Tell the user we can't run tests on partitions, only the devices themselves.
				alert("The test cannot be run on partitions, e.g., "+id+". Please make a different selection.");
				// Deselect their selection.
				document.getElementById(id).checked = false;
			} else { // case: user selected a device, e.g., sda
				// Query to see if there are any html elements with ids representing
				// partitions, e.g., sda1. Does the device the user selected have any
				// partitions?
				if (document.getElementById(id+"1")){
					// warn the user
					var answer = confirm("WARNING!!! The device you selected, "+id+", contains one or more partitions/file systems, e.g., "+id+"1. These may contain an OS or data. In case of the event that the blocker you are testing fails, please only run this test on a device that does not contain user data. Select 'OK' to keep your selection, 'Cancel' to cancel it.");
					// if the user selected 'Cancel', undo their selection
					if (!answer) { 
						document.getElementById(id).checked = false;			
					}
				}
			}	
		} else {
			alert("Error: invalid value for var mounted in ft-global.js/get_common_get_view_check_selection()");
		}
	}
}

/* Legacy */
function formatyourthumb_js_checks(id){ // id is the device the user selected

}

function testinterface_js_checks(id){ // id is the device the user selected

}

// The purpose of testinterface_commandset_check() is to make the commandset checkboxes on 
// testinterface.php behave similarly to radio buttons, i.e., if one box gets checked by the 
// user, deselect any others. 
function testinterface_commandset_check(id){ // id is the device the user clicked
	//alert("test");
	if (id == "ataonly" && document.getElementById("ataonly").checked == true){
		// if you just selected (vs deselected) the ataonly box 
		document.getElementById("scsionly").checked = false;
		document.getElementById("simplescsionly").checked = false;
	} else if (id == "scsionly" && document.getElementById("scsionly").checked == true){
		// if you just selected (vs deselected) the scsionly box 
		document.getElementById("ataonly").checked = false;
		document.getElementById("simplescsionly").checked = false;		
	} else if (id == "simplescsionly" && document.getElementById("simplescsionly").checked == true){
		// if you just selected (vs deselected) the simplescsionly box 
		document.getElementById("scsionly").checked = false;
		document.getElementById("ataonly").checked = false;		
	}
}

// ss_select_all() will select (check) all of the "name" checkboxes; this is useful
// to stringsearch/res.php and customizetest.php
function ss_select_all(name){ 
    // get references for all of the checkboxes we want to check
    checkboxes = document.getElementsByName(name);
    n = checkboxes.length;
    for(var i=0; i<n; i++){ // check them
	checkboxes[i].checked = true;
    }
    //alert("hello, n:"+n);    
}

// ss_deselect_all() will deselect (uncheck) all of the "name" checkboxes; this is useful
// to stringsearch/res.php and customizetest.php
function ss_deselect_all(name){ 
    // get references for all of the checkboxes we want to uncheck
    checkboxes = document.getElementsByName(name);
    n=checkboxes.length;
    for(var i=0; i<n; i++){ // uncheck them
	checkboxes[i].checked = false;
    }
    //alert("hello, n:"+n);    
}

// ss_customizetest_onload() is called every time customizetest.php is loaded
function ss_customizetest_onload(){
	// Each time customizetest.php loads, the checkbox for selecting the Windows dataset will 
	// either be check (i.e., user has been to this page before and had checked it) or not. 
	// If it's not checked, make sure that the 3 Windows-only test cases are disabled. If it 
	// is checked, make sure that they are enabled (clickable).
	if (document.getElementById("Windows").checked == true){
		document.getElementById("FT-SS-09-Frag").disabled = false;
		document.getElementById("FT-SS-09-Lost").disabled = false;
		document.getElementById("FT-SS-09-MFT").disabled = false;
	} else {
		document.getElementById("FT-SS-09-Frag").disabled = true;
		document.getElementById("FT-SS-09-Lost").disabled = true;
		document.getElementById("FT-SS-09-MFT").disabled = true;
	}
}

// ss_customizetest_check_special() is called every time one of the checkboxes for selecting 
// a test dataset is clicked. Its effect is to enable (make clickable) the 3 Windows-only test cases
// when the Windows dataset is checked. When the Windows dataset is unchecked it disables the the 
// 3 Windows-only test cases
function ss_customizetest_check_special(id){
	if (id == "Windows"){ // case: the Windows (vs Unix) dataset was clicked
		if (document.getElementById("Windows").checked == true){ // if it was checked, enable the 3 Windows-only test cases
			document.getElementById("FT-SS-09-Frag").disabled = false;
			document.getElementById("FT-SS-09-Lost").disabled = false;
			document.getElementById("FT-SS-09-MFT").disabled = false;
		} else { // else: disable the 3 Windows-only test cases
			document.getElementById("FT-SS-09-Frag").disabled = true;
			document.getElementById("FT-SS-09-Lost").disabled = true;
			document.getElementById("FT-SS-09-MFT").disabled = true;
		}		
	}
}

// Do all of the checks on the form data from stringsearch/customizetest.php
function ss_customizetest_checks(){

    var toolname = document.forms["testselections"]["toolname"]; // pull back toolname form element
    if (toolname.value == ""){ // did the user enter a name for the tool?
	alert("Please enter a value for tool name.");
	window.location.hash = "nameandversion"; // shift to the right part of the page
	toolname.focus(); // place the focus on the tool name text box
	return false; // returning false prevents the calling form from submitting, i.e., going to the next page
    } 

    toolversion = document.forms["testselections"]["toolversion"];
    if (toolversion.value == ""){ // did the user enter a value for tool version?
	alert("Please enter a value for tool version.");
	window.location.hash = "nameandversion";
	toolversion.focus();
	return false;
    }

    // the user needs to select at least one search engine to test
    engines = document.getElementsByName("engines[]"); // pull back all the engines[] elements
    n = engines.length;
    need_engines = true;
    is_other = false;
    for(var i=0; i<n; i++){ // cycle over all the possible "engine" selections
	if (engines[i].checked == true) {
	    need_engines = false; 
	}
	// If the user selected "other", they need to give us a value for se_other_name
	if (engines[i].value == "Other" && engines[i].checked == true) {
	    if (document.forms["testselections"]["se_other_name"].value == ""){
		alert("Please enter the \"other\" search engine's name.");
		window.location.hash = "engines";
		document.forms["testselections"]["se_other_name"].focus();
		return false;
	    }
	}
    }    
    if (need_engines){
	alert("Please select at least one search engine to test.");
	//window.location("#engines");
	window.location.hash = "engines";
	//engines[0].focus();
	return false;	
    }
    
    // the user needs to select at least one data set to test
    datasets = document.getElementsByName("datasets[]");
    n = datasets.length;
    need_datasets = true;
    for(var i=0; i<n; i++){ 
	if (datasets[i].checked == true) {
	    need_datasets = false;
	}
    }    
    if (need_datasets){
	alert("Please select at least one data set to test.");
	//window.location("#engines");
	window.location.hash = "datasets";	
	//datasets[0].focus();
	return false;	
    }


    /* The user needs to select at least one test to run. Cycle through all the
       tests to make sure the user's selected at least one. */
    tests = document.getElementsByName("basic[]"); // get references to all the basic[] elements
    n = tests.length;
    need_tests = true;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) { // if the user has selected a test, make a note of this...
	    need_tests = false;
	}
    }

    tests = document.getElementsByName("logical[]"); // all the logical[] elements
    n = tests.length;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) {
	    need_tests = false;
	}
    }

    tests = document.getElementsByName("unicode[]"); // all the unicode[] elements
    n = tests.length;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) {
	    need_tests = false;
	}
    }

    tests = document.getElementsByName("tool_defined[]"); // all the tool_defined[] elements
    n = tests.length;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) {
	    need_tests = false;
	}
    }

    tests = document.getElementsByName("special[]"); // all the special[] elements
    n = tests.length;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) {
	    need_tests = false;
	}
    }

    tests = document.getElementsByName("regex[]"); // all the regex[] elements
    n = tests.length;
    for(var i=0; i<n; i++){ 
	if (tests[i].checked == true) {
	    need_tests = false;
	}
    }    

    if (need_tests){ // if the user didn't select at least one test to run, alert them to this
	alert("Please select at least one string search feature to test for your tool.");
	//window.location("#engines");
	window.location.hash = "features"; // move the focus to the "Features" area of the page
	//datasets[0].focus();
	return false;	
    }    
}


